/*
Author: Radek Henys (admin@mouseviator.com)
Version: 1.0b
Last update: 26.3.2014
License: LGPL v3
*/

#include "common.h"
#include "process.h"
#include "window.h"

#define LUA_LIB

//library specific constants
const char* MVH_VERSION = "1.0b";			//version of the library
const char* MVH_AUTHOR = "Radek Henys";		//author of the build
const char* MVH_BD = __DATE__;
const char* MVH_BT = __TIME__;

//Macros
#define lua_setconst(L, v, n)	{lua_pushinteger(L,v); lua_setglobal(L,n); }


//Define the table of functions for process manipulation we are exporting
static const luaL_Reg processlib[] = {
	{ "getprivatebytes", getPrivateBytes},
	{ "getmemoryinfo", getMemoryInfo},
	{ "getid", getProcessID},
	{ "getids", getProcessIDs},
	{ "getaffinity", getAffinity},
	{ "setaffinity", setAffinity},
	{ "gethandle", getHandle},
	{ "closehandle", closeHandle},
	{ "getpriority", getPriority},
	{ "setpriority", setPriority},
	{NULL,NULL}
};

//Define table of functions for window manipulation we are exporting
static const luaL_Reg windowLib[] = {
	{ "gethandles", getWindowHandles },
	{ "find", findWindow },
	{ "gettext", getWindowText },
	{ "getsize", getWindowSize },
	{ "getclientsize", getClientSize},
	{ "move", moveWindow },
	{ "setposition", setWindowPos},
	{ "isforeground", isForeground},
	{ "setforeground", setForeground},
	{ "restore", restoreWindow},
	{ "minimize", minimizeWindow},
	{ "maximize", maximizeWindow},
	{ "isfullscreen", isFullScreen},
	{ "setfullscreen", setFullScreen},
	{ "setwindowed", setWindowed},
	{ "getstyle", getWindowStyle},
	{ "setstyle", setWindowStyle},
	{ "sendmessage", sendMessage},
	{ NULL, NULL }
};

//export defined functions
extern "C"
int __declspec(dllexport) luaopen_mouseviatorhelper(lua_State *L) {
	//register functions
	luaL_register(L, "process", processlib);
	luaL_register(L, "window", windowLib);

	//export constants
	lua_setconst(L, ABOVE_NORMAL_PRIORITY_CLASS, "P_ABOVE_NORMAL");
	lua_setconst(L, BELOW_NORMAL_PRIORITY_CLASS, "P_BELOW_NORMAL");
	lua_setconst(L, HIGH_PRIORITY_CLASS, "P_HIGH");
	lua_setconst(L, IDLE_PRIORITY_CLASS, "P_IDLE");
	lua_setconst(L, NORMAL_PRIORITY_CLASS, "P_NORMAL");
	lua_setconst(L, REALTIME_PRIORITY_CLASS, "P_REALTIME");
	lua_setconst(L, WSOP_ADD, "WSOP_ADD");
	lua_setconst(L, WSOP_REMOVE, "WSOP_REMOVE");
	lua_setconst(L, WSOP_REPLACE, "WSOP_REPLACE");
	lua_setconst(L, WE_ALL, "WE_ALL");
	lua_setconst(L, WE_TOPLEVELONLY, "WE_TOPLEVELONLY");

	//export library info
	//version
	lua_pushstring(L, MVH_VERSION);
	lua_setglobal(L, "MVH_VERSION");
	//author
	lua_pushstring(L, MVH_AUTHOR);
	lua_setglobal(L, "MVH_AUTHOR");
	//build date and time
	lua_pushstring(L, MVH_BD);
	lua_setglobal(L, "MVH_BD");
	lua_pushstring(L, MVH_BT);
	lua_setglobal(L, "MVH_BT");

	return 1;
};